/**
 * EMthemes
 *
 * @license commercial software
 * @copyright (c) 2014 Codespot Software JSC - EMthemes.com. (http://www.emthemes.com)
 */
var timeout = null;
var touch = false;
var animate = false;
(function($) {
	if (typeof EM == 'undefined') EM = {};
	if (typeof EM.tools == 'undefined') EM.tools = {};

	var domLoaded = false;
	var windowLoaded = false;

	/**
	 *   Add class mobile
	 **/

	function addClassMobile() {
		if (isMobile) {
			$('body').addClass('mobile-view');
		}
	};

	/**
	 * Fix iPhone/iPod auto zoom-in when text fields, select boxes are focus
	 */

	function fixIPhoneAutoZoomWhenFocus() {
		var viewport = $('head meta[name=viewport]');
		if (viewport.length == 0) {
			$('head').append('<meta name="viewport" content="width=device-width, initial-scale=1.0"/>');
			viewport = $('head meta[name=viewport]');
		}

		var old_content = viewport.attr('content');

		function zoomDisable() {
			viewport.attr('content', old_content + ', user-scalable=0');
		}

		function zoomEnable() {
			viewport.attr('content', old_content);
		}

		$("input[type=text], textarea, select").mouseover(zoomDisable).mousedown(zoomEnable);
	};

	/* hover language currency */

	function hoverUl() {
		if (!isMobile) {
			$('#select-language').each(function() {
				$(this).insertUlLanguage();
				$(this).selectUl();
			});
			$('.currency').each(function() {
				$(this).insertUl();
				$(this).selectUl();
			});
			$('#select-store').each(function() {
				$(this).insertUl();
				$(this).selectUl();
			});
		}
	};

	function persistentMenu() {
		if (FREEZED_TOP_MENU != 0 && !isPhone) {
			var sticky_navigation = function() {
				var scroll_top = $(window).scrollTop();
				//var navpos = $('#navpos').offset().top;
				if ($(window).width() > 767) {
					if (scroll_top > 0) {
						$('.header-bottom-left').addClass('navbar-fixed-top');
					} else {
						$('.header-bottom-left').removeClass('navbar-fixed-top');
					}
				} else {
					$('.header-bottom-left').removeClass('navbar-fixed-top');
				}
			};
			$(window).scroll(function() {
				sticky_navigation();
			});
		}
		if ($(window).width() <= 767) {
			$('.header-bottom-left').removeClass('navbar-fixed-top');
		}
	};

	// Back to top

	function backToTop() {
		// hide #back-top first
		$("#back-top").hide();

		// fade in #back-top
		if (!isMobile) {
			$(window).scroll(function() {
				if ($(this).scrollTop() > 100) {
					$('#back-top').fadeIn();
				} else {
					$('#back-top').fadeOut();
				}
			});

			// scroll body to 0px on click
			$('#back-top a').click(function() {
				$('body,html').animate({
					scrollTop: 0
				}, 800);
				return false;
			});
		}
	};

	/* Top Cart Hover */

	function hoverTopCart() {
		$('.dropdown-cart').each(function() {
			if (isMobile) {
				$('.dropdown-cart').find('.amount').attr('href', 'javascript:void(0);');
				$(this).unbind('click');
				var divWrapper = $(this);
				$(this).find('.icon.cart,.amount').click(function(e) {
					e.preventDefault();
					divWrapper.find('.cart-popup').slideToggle(function(){
						$(this).css("overflow","inherit")});
				});
			} else {
				var tm;

				function show(el) {
					clearTimeout(tm);
					tm = setTimeout(function() {
					el.slideDown(function(){
						$(this).css("overflow","inherit")});	
					}, 200);
				}

				function hide(el) {
					clearTimeout(tm);
					tm = setTimeout(function() {
						el.slideUp(function(){
						$(this).css("overflow","inherit")});
					}, 200);
				}
				$(this).bind('mouseenter', show.curry($('.cart-popup', this))).bind('mouseleave', hide.curry($('.cart-popup', this))).find('.cart-popup').slideUp();
			}
		});
	};
			
	/**
	 Tab On Details Page
	 */

	function decorateProductCollateralTabs() {
		if ($('.box-collateral').length > 1) {
			$('.product-collateral').each(function(i) {
				$(this).wrap('<div class="tabs_wrapper_detail collateral_wrapper" />');
				$(this).prepend('<ul class="tabs_control"></ul>');
				$(this).children(".product-collateral-item").addClass("ui-slider-tabs-content-container");

				$('.box-collateral', this).addClass('tab-item').each(function(j) {
					var id = 'box_collateral_' + i + '_' + j;
					$(this).addClass('content_' + id);
					$(this).attr('id', id);
					$('.tabs_wrapper_detail ul.tabs_control').append('<li><a href="#' + id + '">' + $('h2', this).html() + '</a></li>');
				});
				$("div.tabs_wrapper_detail .product-collateral").sliderTabs();
			});

		}
	};
	/**
	 Tab On Details Page
	 */

	function decorateProductCollateralTabsUpsellRelated() {
		if ($('.box-collateral-2').length > 1) {
			$('.product-tab-2').each(function(i) {
				$(this).wrap('<div class="tabs_wrapper_detail-2 collateral_wrapper" />');
				$(this).prepend('<ul class="tabs_control"></ul>');
				$(this).children(".product-collateral-item").addClass("ui-slider-tabs-content-container");

				$('.box-collateral-2', this).addClass('tab-item').each(function(j) {
					var id = 'box_collateral_' + i + '_' + j;
					$(this).addClass('content_' + id);
					$(this).attr('id', id);
					$('.tabs_wrapper_detail-2 ul.tabs_control').append('<li><a href="#' + id + '">' + $('h2', this).html() + '</a></li>');
				});
				$("div.tabs_wrapper_detail-2 .product-tab-2").sliderTabs();
			});

		}
	};

	/**
	 *   showReviewTab
	 **/

	function showReviewList() {
		if (jQuery('#customer-reviews').size()) {
			// scroll to customer review
			jQuery('html, body').animate({
				scrollTop: jQuery('#customer-reviews').offset().top
			}, 500);
		} else {
			return false;
		}
		return true;
	};

	function showReviewForm() {
		if (jQuery('#review-form').size()) {
			// scroll to customer review
			jQuery('html, body').animate({
				scrollTop: jQuery('#review-form').offset().top
			}, 500);
		} else {
			return false;
		}
		return true;
	};

	function setupReviewLink() {
		jQuery('.product-view .product-essential .link_review_list').click(function(e) {
			if (showReviewList()) {
				e.preventDefault();
			}
		});
		jQuery('.product-view .product-essential .link_review_form').click(function(e) {
			if (showReviewForm()) {
				e.preventDefault();
			}
		});
	};

	/* on resize */
	/*window.onresize = function() {
		if (($('#image') != null) && (product_zoom != null)) {
			$('#image').width(product_zoom.imageDim.width);
			Event.stopObserving($('#zoom_in'), 'mousedown', product_zoom.startZoomIn.bind(product_zoom));
			Event.stopObserving($('#zoom_in'), 'mouseup', product_zoom.stopZooming.bind(product_zoom));
			Event.stopObserving($('#zoom_in'), 'mouseout', product_zoom.stopZooming.bind(product_zoom));

			Event.stopObserving($('#zoom_out'), 'mousedown', product_zoom.startZoomOut.bind(product_zoom));
			Event.stopObserving($('#zoom_out'), 'mouseup', product_zoom.stopZooming.bind(product_zoom));
			Event.stopObserving($('#zoom_out'), 'mouseout', product_zoom.stopZooming.bind(product_zoom));

			product_zoom = new Product.Zoom('image', 'track', 'handle', 'zoom_in', 'zoom_out', 'track_hint');;
		}
	};*/

	/**
	 Do Slider
	 */

	function doSlider($e, $move, $circular, $direction) {
		if ($($e + ' ul > li').size() > 1) {
			$($e + ' > ul').addClass('slides');
			$($e).csslider({
				move: $move,
				circular: $circular,
				direction: $direction,
				parentHidden: 'div.slider'
			});
		}
	};

	function toogleStore() {
		if (!isMobile) {
			doSlider('#slider_storeview', 1, 0, 'horizontal');
			$('.storediv').hide();
			$(".btn_storeview").click(function() {
				store_show();
			});
			$(".btn_storeclose").click(function() {
				store_hide();
			});

			function store_show() {
				var bg = $("#bg_fade_color");
				bg.css("opacity", 0.5);
				bg.css("display", "block");
				var top = ($(window).height() - $(".storediv").height()) / 2;
				var left = ($(window).width() - $(".storediv").width()) / 2;
				$(".storediv").show();
				$(".storediv").css('top', top + 'px');
				$(".storediv").css('left', left + 'px');
			};

			function store_hide() {
				var bg = $("#bg_fade_color");
				$(".storediv").hide();
				bg.css("opacity", 0);
				bg.css("display", "none");
			};
		}
	};

	function qrCode() {
		$('#qr_code .qr_code_name a').mouseover(function(e) {
			var $img = $('img', this);
			$img.css({
				'display': 'block'
			}).attr('src', $img.data('originalImg'));

			var parent = $img.offsetParent().offset();
			//var left = e.pageX - parent.left + 15;
			var top = e.pageY - parent.top + 15;

			if ((parent.top + top + $img.height()) > ($(document).scrollTop() + $(window).height())) top = $(document).scrollTop() + $(window).height() - $img.height() - parent.top;

			if ((parent.top + top) < $(document).scrollTop()) top = $(document).scrollTop() - parent.top;

			$img.css({
				'left': 48 + 'px',
				'position': 'absolute',
				'top': 0 + 'px',
				'width': 'auto',
				'height': 'auto'
			}).attr('src', $img.data('originalImg'));
		});

		$('#qr_code .qr_code_name a').mouseout(function(e) {
			var $img = $('img', this);
			$img.css({
				'display': 'none'
			}).attr('src', $img.data('originalImg'));
		});
	};



	/**
	 *   Toogle Footer Information Mobile View
	 **/

	function toogleFooter() {
		var wi = $(window).width();
		if (isPhone || (wi <= 767)) {
			$('.link_content > div > .content_links').css('display', 'none');
			$('.link_content > div > p.h5').addClass('toogle-icon');
			$('.link_content > div > p.h5').unbind('click');
			$('.link_content > div > p.h5').on('click', function() {
				$(this).toggleClass("active").parent().find(".content_links").slideToggle();
			});
		} else {
			$('.link_content > div > p.h5').unbind('click');
			$('.link_content > div > p.h5').removeClass('toogle-icon');
			$('.link_content > div > p.h5').removeClass('active');
			$('.link_content > div > .content_links').css('display', 'block');
		}
	};

	function buildBootrapJs() {
		$('.link_connect a.icon').tooltip();

		$('.reset-button').click(function() {
			var btn = $(this);
			btn.button('loading');
            var tm;
            clearTimeout(tm);
			tm = setTimeout(function() {
				btn.button('reset');
			}, 1000);
		});
	};

	function dataAnimate() {
		if ($('[data-animate]')) {
			$('[data-animate]').each(function() {

				var $toAnimateElement = $(this);

				var toAnimateDelay = $(this).attr('data-delay');

				var toAnimateDelayTime = 0;

				if (toAnimateDelay) {
					toAnimateDelayTime = Number(toAnimateDelay);
				} else {
					toAnimateDelayTime = 200;
				}

				if (!$toAnimateElement.hasClass('animated')) {

					/*$toAnimateElement.addClass('not-animated');*/

					var elementAnimation = $toAnimateElement.attr('data-animate');
					setTimeout(function() {
						$toAnimateElement.waypoint({
							handler: function() {
								$toAnimateElement.removeClass('not-animated').addClass(elementAnimation + ' animated');
							},
							offset: '100%',
							triggerOnce: false
						});
					}, toAnimateDelayTime);
				}
				if ($toAnimateElement.hasClass('not-animated')) animate = false;
			});
		}

	};

	function ieVersion() {
		var rv = -1; // Return value assumes failure.
		if (navigator.appName == 'Microsoft Internet Explorer') {
			var ua = navigator.userAgent;
			var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
			if (re.exec(ua) != null) rv = parseFloat(RegExp.$1);
		}
		return rv;
	};

	function doAnimate() { /* DETECT PLATFORM */
		$.support.touch = 'ontouchend' in document;

		if ($.support.touch) {
			touch = true;
			$('body').addClass('touch');
		} else {
			$('body').addClass('notouch');
		}
		if (touch == false && ANIMATION_LOADING == 0) {
			if (ieVersion() == -1 || ieVersion() > 9) $('[data-animate]').addClass('not-animated');
		}
	};

	function setAnimate() {
		$('.header-top-left').each(function() {
			if (!$(this).hasClass('clear') && !$(this).hasClass('bkg-hover')) $(this).attr('data-animate', animate_header);
		});
		$('.header-top-right').each(function() {
			if (!$(this).hasClass('clear') && !$(this).hasClass('bkg-hover')) $(this).attr('data-animate', animate_header);
		});
		$('.header-bottom .logo_wrapper .row .col-sm-24').children('div').each(function() {
			$(this).children('div').each(function() {
				if (!$(this).hasClass('clear') && !$(this).hasClass('bkg-hover')) $(this).attr('data-animate', animate_header);
			});
		});
		$('.em_left').children('div').each(function() {
			$(this).children('div').each(function() {
				if (!$(this).hasClass('clear') && !$(this).hasClass('bkg-hover')&& !$(this).hasClass('megamenu-wrapper')) $(this).attr('data-animate', animate_left);
			});
		});
		$('.em_right').children('div').each(function() {
			$(this).children('div').each(function() {
				if (!$(this).hasClass('clear') && !$(this).hasClass('bkg-hover')&& !$(this).hasClass('megamenu-wrapper')) $(this).attr('data-animate', animate_right);
			});
		});
		$('.em_main').children('div').each(function() {
			$(this).children('div').each(function() {
				if (!$(this).parents().first().hasClass('tab_home') && !$(this).hasClass('clear') && !$(this).hasClass('bkg-hover')) $(this).attr('data-animate', animate_main);
			});
		});
		$('.area3-banner').children('div').each(function() {
			$(this).children('div').each(function() {
				if (!$(this).hasClass('clear') && !$(this).hasClass('bkg-hover')) $(this).attr('data-animate', animate_main);
			});
		});
		$('.area6-links,.footer-container, .area12-payment,.area7-network-newsletter').children('div').each(function() {
			$(this).children('div').each(function() {
				if (!$(this).hasClass('clear') && !$(this).hasClass('bkg-hover')) $(this).attr('data-animate', animate_footer);
			});
		});
	};

    
    function colorVariation(){
        var screen = "<div id='bg_fade_color'></div>";
		$(document.body).append(screen);
		$("#bg_fade_color").css("opacity",0);
    	$("#bg_fade_color").css("display","none");
				
		$(".btn_color_variation").click(function() {
			var bg	=	$("#bg_fade_color");
			bg.css("opacity",0.5);
			bg.css("visibility","visible");
			$(".colordiv").show();
			
			$(".colordiv").css('top', Math.max($(document).scrollTop(), Math.min($(this).offset().top, $(document).scrollTop() + $(window).height() - $(".colordiv").outerHeight())) + 20 + 'px');

			var bg = $("#bg_fade");
			bg.css("opacity",0.5);
			bg.css("visibility","visible");
		});
		
		$(".btn_color_close").click(function() {
			color_hide();
		});
		
		function color_hide(){
			var bg = $("#bg_fade");
			$(".colordiv").hide();
			bg.css("opacity",0);
			bg.css("visibility","hidden");
		}
    };

	/**
	 Ready Function
	 */
	$(document).ready(function() {
		domLoaded = true;
		setAnimate();
		addClassMobile();
		if(fullSlideshow){
			$('.em-slideshow').addClass('em-full-custom');
		}else{
			$('.em-slideshow').removeClass('em-full-custom');
		};
        if(disableVariation!=1){
            colorVariation();
            qrCode();   
            toogleStore(); 
        }        
		// safari hack: remove bold in h5, .h5
		if (navigator.userAgent.indexOf('Safari') != -1 && navigator.userAgent.indexOf('Chrome') == -1) {
			$('h1, .h1, h2, .h2, h3, .h3, h4, .h4, h5, .h5, h6, .h6').css('font-weight', 'normal');
		}
		isMobile && fixIPhoneAutoZoomWhenFocus();
		hoverUl();
		toolbarCategoty();
		backToTop();
		hoverTopCart();
		alternativeProductImage();
		
		setupReviewLink();
		doSlider('#upsell-product-table', 1, 0, 'horizontal');
		doSlider('#slider_crosell', 1, 0, 'horizontal');
		doSlider('#slider_moreview', 1, 0, 'horizontal');
		doSlider('#slider_related', 1, 0, 'horizontal');
		if (useTab) {
			decorateProductCollateralTabs();
			decorateProductCollateralTabsUpsellRelated();
		}
		responsive();
		persistentMenu();
		toogleFooter();
		var tm;
		$(window).resize(function() {
			if (tm) {
				clearTimeout(tm);
			}
			tm = setTimeout(function() {
				toogleFooter();
				if (typeof em_slider !== 'undefined') em_slider.reinit();
			}, 300);
		});
		buildBootrapJs();

		if ($('.wrapper').hasClass('em-box-custom')) {
			if ($('body').hasClass('adapt-0')) {
				$('.wrapper').removeClass('em-box-custom');
			}
			$(window).bind('resize', function() {
				if ($('body').hasClass('adapt-0')) {
					$('.wrapper').removeClass('em-box-custom');
				} else {
					$('.wrapper').addClass('em-box-custom');
				}
			});
		}
		doAnimate();
	});

	/**
	 Load Function
	 */
	$(window).bind('load', function() {
		windowLoaded = true;
		$.support.touch = 'ontouchend' in document;

		if ($.support.touch) {
			touch = true;
			$('body').addClass('touch');
		} else {
			$('body').addClass('notouch');
		}
		if (touch == false && ANIMATION_LOADING == 0) {
			if (ieVersion() == -1 || ieVersion() > 9) {
				dataAnimate();
			}
		}
		initIsotope();
	});

	$(window).resize(function() {
		if (!animate) {
			if (touch == false && ANIMATION_LOADING == 0) {
				if (ieVersion() == -1 || ieVersion() > 9) dataAnimate();
			}
		}
		var tm;
		clearTimeout(tm);
		tm = setTimeout(initIsotope, 500);
	});

	$(window).bind('orientationchange', function() {});

})(jQuery);

	/**
	 * Adjust elements to make it responsive
	 */

	function responsive() {
		var $ = jQuery;
		var position = $('.products-grid .item').css('position');
		if (position != 'absolute' && position != 'fixed' && position != 'relative') $('.products-grid .item').css('position', 'relative');
	};

/**
 * Change the alternative product image when hover
 */

function alternativeProductImage() {
	var $ = jQuery;
	var tm;

	function swap() {
		clearTimeout(tm);
		tm = setTimeout(function() {
			el = $(this).find('img[data-alt-src]');
			var newImg = $(el).data('alt-src');
			var oldImg = $(el).attr('src');
			$(el).attr('src', newImg).data('alt-src', oldImg);
		}.bind(this), 200);
	}

	$('.item .product-image img[data-alt-src]').parents('.item').bind('mouseenter', swap).bind('mouseleave', swap);
};

function toolbarCategoty() {
	var $ = jQuery;
	if (!isMobile) {
		$('.toolbar-show').each(function() {
			$(this).insertUl();
			$(this).selectUl();
		});
		$('.sortby').each(function() {
			$(this).insertUl();
			$(this).selectUl();
		});
	}
};

/**
 *   After Layer Update
 **/
window.afterLayerUpdate = function() {
	var $ = jQuery;
	toolbarCategoty();
	alternativeProductImage();
	if (typeof EM_QUICKSHOP_DISABLED == 'undefined' || !EM_QUICKSHOP_DISABLED) {
		qs({
			itemClass: '.products-grid li.item, .products-list li.item',
			//selector for each items in catalog product list,use to insert quickshop image
			aClass: 'a.product-image',
			//selector for each a tag in product items,give us href for one product
			imgClass: '.product-image img' //class for quickshop href
		});
	}
	initIsotope(); 
};
function afterLoadAjax(id){
	responsive();
	if(!isPhone){
		var temp = jQuery(id + ' ul.products-grid li.item');	
		temp.each(function(){
			if(!(jQuery(this).hasClass('isotope-item'))){
				jQuery(id + ' ul.ajax-product ').isotope( 'insert', jQuery(this));
			}
		});
	};    
	alternativeProductImage();
	if (typeof EM_QUICKSHOP_DISABLED == 'undefined' || !EM_QUICKSHOP_DISABLED){
		qs({
			itemClass: '.products-grid li.item, .products-list li.item, li.item .cate_product, .product-upsell-slideshow li.item, .mini-products-list li.item, #crosssell-products-list li.item', //selector for each items in catalog product list,use to insert quickshop image
			aClass: 'a.product-image', //selector for each a tag in product items,give us href for one product
			imgClass: '.product-image img' //class for quickshop href
		});
	}
};
	
function hideAgreementPopup(e) {
	jQuery('#checkout-agreements .agreement-content').hide();
};

function showAgreementPopup(e) {
	jQuery('#checkout-agreements label.a-click').parent().parent().children('.agreement-content').show().css({
		'left': (parseInt(document.viewport.getWidth()) - jQuery('#checkout-agreements label.a-click').parent().parent().children('.agreement-content').width()) / 2 + 'px',
		'top': (parseInt(document.viewport.getHeight()) - jQuery('#checkout-agreements label.a-click').parent().parent().children('.agreement-content').height()) / 2 + 'px'
	});
};

function initIsotope(){
	if(!isPhone){	
	var itemwidth = jQuery('.category-products ul.ajax-product li').first().width();
	
	jQuery.Isotope.prototype._getMasonryGutterColumns = function() {
	    var gutter = this.options.masonry && this.options.masonry.gutterWidth || 0;
	        containerWidth = this.element.width();
	  
	    this.masonry.columnWidth = this.options.masonry && this.options.masonry.columnWidth ||
	                  // or use the size of the first item
	                  this.$filteredAtoms.outerWidth(true) ||
	                  // if there's no items, use size of container
	                  containerWidth;

	    this.masonry.columnWidth += gutter;

	    this.masonry.cols = Math.floor( ( containerWidth + gutter ) / this.masonry.columnWidth );
	    this.masonry.cols = Math.max( this.masonry.cols, 1 );
	  };

	  jQuery.Isotope.prototype._masonryReset = function() {
	    // layout-specific props
	    this.masonry = {};
	    // FIXME shouldn't have to call this again
	    this._getMasonryGutterColumns();
	    var i = this.masonry.cols;
	    this.masonry.colYs = [];
	    while (i--) {
	      this.masonry.colYs.push( 0 );
	    }
	  };

	  jQuery.Isotope.prototype._masonryResizeChanged = function() {
	    var prevSegments = this.masonry.cols;
	    // update cols/rows
	    this._getMasonryGutterColumns();
	    // return if updated cols/rows is not equal to previous
	    return ( this.masonry.cols !== prevSegments );
	  };
	jQuery('.category-products ul.ajax-product').isotope({
		itemSelector : '.item',
		masonry : {
	      },
	      layoutMode : PRODUCTSGRID_POSITION_ABSOLUTE,
	});

	}	
};